/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.data.FRUOriginal;
import com.ibm.hsc.auiml.databeans.sfp.data.ManagedObject;
import com.ibm.hsc.auiml.databeans.sfp.data.ServiceableEvent;
import com.ibm.hsc.auiml.databeans.sfp.data.StructuredData;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.RMCUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.sfp.surveillance.Surveillance;
import com.ibm.hsc.sfp.surveillance.SurveillanceEvent;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventList;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionConnectionState;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionStateList;
import com.ibm.hsc.sfp.surveillance.SurveillanceTimerThreadState;
import com.ibm.rsct.rmc.McResource;
import com.ibm.rsct.rmc.McResourceClass;
import com.ibm.rsct.rmc.McSession;
import com.ibm.rsct.rmc.McSessionEndedCB;
import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.rmcjni.McErrNumException;
import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CuException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class SurveillanceTimerThread
implements Runnable {
    private static final String TRACE_MASKD = "JSURVTTD";
    private static final String TRACE_MASKF = "JSURVTTF";
    private static final String TRACE_MASKT = "JSURVTTT";
    private static final String SERVICERM_DIR = "/var/ct/IW/log/mc/IBM.ServiceRM/";
    private static final Locale ENGLISH_US = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
    private static final String MANAGED_NODES_ATTRIBUTE_NAME = "Nodes";
    private static final int ID_MANAGED_OBJECTS = 14;
    private static final String FRU_LIST_ATTRIBUTE_NAME = "FRUList";
    private static final int LOWEST_ID_VALUE_MINUS_1 = 0;
    private static final int LOWEST_ID_VALUE = 1;
    private SurveillanceTimerThreadState state = SurveillanceTimerThreadState.NOT_RUNNING;
    private SurveillanceEventList eventList;
    private SurveillancePartitionStateList partitionStates;
    private Surveillance surveillance;

    SurveillanceTimerThread(SurveillanceEventList surveillanceEventList, SurveillancePartitionStateList surveillancePartitionStateList, Surveillance surveillance) {
        this.eventList = surveillanceEventList;
        this.partitionStates = surveillancePartitionStateList;
        this.surveillance = surveillance;
    }

    public native int Surveillance_DoCmd(int var1, String[] var2);

    public static void main(String[] stringArray) {
        SurveillanceEventList surveillanceEventList = null;
        SurveillancePartitionStateList surveillancePartitionStateList = null;
        Surveillance surveillance = null;
        SurveillanceEvent surveillanceEvent = null;
        String string = "0001";
        String string2 = "partition1";
        String string3 = "partition1.endicott.ibm.com";
        Date date = new Date();
        SurveillanceEventType surveillanceEventType = SurveillanceEventType.DISCONNECT;
        String string4 = "1234-123";
        String string5 = "1234567";
        String string6 = "ZZZZ";
        String string7 = "5678-123";
        String string8 = "7654321";
        surveillance = new Surveillance();
        surveillancePartitionStateList = new SurveillancePartitionStateList(surveillance);
        surveillanceEvent = new SurveillanceEvent(string, string2, string3, date, surveillanceEventType, string4, string5, string6, string7, string8);
        surveillanceEventList = new SurveillanceEventList(surveillance, surveillancePartitionStateList);
        new SurveillanceTimerThread(surveillanceEventList, surveillancePartitionStateList, surveillance).processSE(surveillanceEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long l = 0L;
        Date date = null;
        while (true) {
            try {
                while (true) {
                    SurveillanceEventList surveillanceEventList = this.eventList;
                    synchronized (surveillanceEventList) {
                        try {
                            date = (Date)this.eventList.firstKey();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            date = null;
                        }
                        if (date != null) {
                            l = date.getTime() - new Date().getTime();
                            Trace.trace(TRACE_MASKD, "Timer thread found first entry with timeout of " + l);
                            if (l > 0L) {
                                Trace.trace(TRACE_MASKD, "Timer thread starting to sleep for " + l + " milliseconds or until notified.");
                                try {
                                    this.eventList.wait(l);
                                    Trace.trace(TRACE_MASKD, "Timer thread woke up.");
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.eventList.isEmpty()) {
                            this.setState(SurveillanceTimerThreadState.NOT_RUNNING);
                            return;
                        }
                        this.processList();
                    }
                }
            }
            catch (Throwable throwable) {
                Trace.trace(TRACE_MASKF, "Throwable caught in timer thread: " + throwable);
                new AusMicrocodeLog(Surveillance.SURVEILLANCE_TIMER_THREAD_LOG_INFO, 8, throwable).writeEntry(null);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    void setState(SurveillanceTimerThreadState surveillanceTimerThreadState) {
        Trace.trace(TRACE_MASKD, "State of timer thread being set to " + surveillanceTimerThreadState);
        this.state = surveillanceTimerThreadState;
    }

    SurveillanceTimerThreadState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup() {
        Trace.trace(TRACE_MASKT, "-> wakeup()");
        SurveillanceEventList surveillanceEventList = this.eventList;
        synchronized (surveillanceEventList) {
            this.eventList.notify();
        }
        Trace.trace(TRACE_MASKT, "<- wakeup()");
    }

    private void processList() {
        Iterator iterator;
        Date date = null;
        Set set = null;
        Date date2 = null;
        SurveillanceEvent surveillanceEvent = null;
        Vector<SurveillanceEvent> vector = null;
        Trace.trace(TRACE_MASKT, "-> processList()");
        date = new Date();
        set = this.eventList.keySet();
        vector = new Vector<SurveillanceEvent>();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            date2 = (Date)iterator2.next();
            Trace.trace(TRACE_MASKD, "comparing key of " + StructuredData.TS_FORMATTER.format(date2) + " to current time of " + StructuredData.TS_FORMATTER.format(date));
            if (date2.compareTo(date) > 0) continue;
            iterator = ((Vector)this.eventList.get(date2)).iterator();
            while (iterator.hasNext()) {
                surveillanceEvent = (SurveillanceEvent)iterator.next();
                this.process(surveillanceEvent, date2);
                if (!surveillanceEvent.getType().equals(SurveillanceEventType.CONNECT)) continue;
                vector.add(surveillanceEvent);
            }
            iterator2.remove();
            this.eventList.doDebug("removed event so the events are now : ");
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            surveillanceEvent = (SurveillanceEvent)iterator.next();
            this.eventList.delete(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillanceEventType.NOT_YET_CONNECTED);
        }
        Trace.trace(TRACE_MASKT, "<- processList()");
    }

    private void process(SurveillanceEvent surveillanceEvent, Date date) {
        SurveillancePartitionConnectionState surveillancePartitionConnectionState = null;
        Trace.trace(TRACE_MASKT, "-> process(" + surveillanceEvent + ", " + date + ")");
        if (surveillanceEvent.getType().equals(SurveillanceEventType.CONNECT)) {
            this.partitionStates.setStableConnectionState(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillancePartitionConnectionState.CONNECTED);
        } else if (surveillanceEvent.getType().equals(SurveillanceEventType.DISCONNECT)) {
            surveillancePartitionConnectionState = this.partitionStates.getStableConnectionState(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId());
            if (surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED) && this.surveillance.doSurveillancePerConfig(surveillanceEvent.getPartitionId(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS()) && surveillanceEvent.getPartitionCIMState() != null && surveillanceEvent.getPartitionCIMState().intValue() == 8 && !surveillanceEvent.getBecameNotRunning()) {
                this.processSE(surveillanceEvent);
            }
            this.partitionStates.setStableConnectionState(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillancePartitionConnectionState.NOT_CONNECTED);
        } else if (surveillanceEvent.getType().equals(SurveillanceEventType.NOT_YET_CONNECTED) && this.surveillance.doSurveillancePerConfig(surveillanceEvent.getPartitionId(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS()) && surveillanceEvent.getPartitionCIMState() != null && surveillanceEvent.getPartitionCIMState().intValue() == 8 && !surveillanceEvent.getBecameNotRunning()) {
            this.processSE(surveillanceEvent);
        }
        Trace.trace(TRACE_MASKT, "<- process()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSE(SurveillanceEvent surveillanceEvent) {
        boolean bl = true;
        McResource mcResource = null;
        McSession mcSession = null;
        ManagedObjectEntry managedObjectEntry = null;
        Date date = null;
        Trace.trace(TRACE_MASKT, "-> processSE(" + surveillanceEvent + ")");
        Vector vector = null;
        try {
            mcSession = this.createSession();
            vector = SurveillanceTimerThread.getSEs(mcSession, surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS());
            if (vector.size() > 0) {
                date = new Date();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    String string;
                    mcResource = (McResource)iterator.next();
                    Trace.trace(TRACE_MASKD, "Processing serviceable event of " + mcResource);
                    Date date2 = SurveillanceTimerThread.latestTimeOfSE(mcResource);
                    if (date2 == null || date.getTime() >= date2.getTime() + this.eventList.getSurveillance().getNewSETimer() || (string = SurveillanceTimerThread.getErrorCode(mcResource)) == null || !string.equals(surveillanceEvent.getErrorCode())) continue;
                    bl = false;
                    managedObjectEntry = this.getPartitionInSE(surveillanceEvent.getPartitionId(), mcResource);
                    if (managedObjectEntry != null) {
                        SurveillanceTimerThread.incDup(managedObjectEntry, mcResource, date);
                        break;
                    }
                    SurveillanceTimerThread.addPartition(surveillanceEvent, mcResource, date);
                    break;
                }
            }
            if (bl) {
                SurveillanceTimerThread.createSE(surveillanceEvent, SurveillanceTimerThread.createUniqueId(vector));
            }
        }
        catch (SFPException sFPException) {
            new AusMicrocodeLog(Surveillance.SURVEILLANCE_TIMER_THREAD_LOG_INFO, 0, sFPException).writeEntry(null);
        }
        finally {
            if (mcSession != null) {
                try {
                    mcSession.endSession();
                    mcSession = null;
                }
                catch (CuException cuException) {
                    Trace.trace(TRACE_MASKF, "Exception caught ending session: " + (Object)((Object)cuException));
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- processSE(" + surveillanceEvent + ")");
    }

    private static Date latestTimeOfSE(McResource mcResource) {
        Object var1_1 = null;
        McAttribute mcAttribute = null;
        CtDataType[] ctDataTypeArray = null;
        Date date = null;
        Date date2 = null;
        ManagedObject managedObject = null;
        Exception exception = null;
        Trace.trace(TRACE_MASKT, "-> latestTimeOfSE(" + mcResource + ")");
        try {
            mcAttribute = mcResource.getPersistentAttribute(MANAGED_NODES_ATTRIBUTE_NAME);
        }
        catch (McErrNumException mcErrNumException) {
            exception = new Exception(mcErrNumException.getMessage());
        }
        catch (CuException cuException) {
            exception = new Exception(cuException.getMessage());
        }
        if (exception == null) {
            if (mcAttribute != null) {
                ctDataTypeArray = ((CtArray)mcAttribute.getValue()).getData();
                int n = 0;
                while (n < ctDataTypeArray.length) {
                    managedObject = new ManagedObject((CtStructuredData)ctDataTypeArray[n], Locale.getDefault());
                    date2 = managedObject.getLastTimestampDate();
                    if (date2 != null || (date2 = managedObject.getOrigTimestampDate()) != null) {
                        if (date == null) {
                            date = date2;
                        } else if (date2.compareTo(date) > 0) {
                            date = date2;
                        }
                    }
                    ++n;
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "latestTimeOfSE() caught: " + exception);
        }
        Trace.trace(TRACE_MASKT, "<- latestTimeOfSE(...) returning " + date);
        return date;
    }

    private static String getErrorCode(McResource mcResource) {
        McAttribute mcAttribute = null;
        CtDataType[] ctDataTypeArray = null;
        FRUOriginal fRUOriginal = null;
        Exception exception = null;
        String string = null;
        Trace.trace(TRACE_MASKT, "-> getErrorCode(" + mcResource + ")");
        try {
            mcAttribute = mcResource.getPersistentAttribute(FRU_LIST_ATTRIBUTE_NAME);
        }
        catch (McErrNumException mcErrNumException) {
            exception = new Exception(mcErrNumException.getMessage());
        }
        catch (CuException cuException) {
            exception = new Exception(cuException.getMessage());
        }
        if (exception == null) {
            if (mcAttribute != null) {
                ctDataTypeArray = ((CtArray)mcAttribute.getValue()).getData();
                fRUOriginal = new FRUOriginal((CtStructuredData)ctDataTypeArray[0]);
                string = fRUOriginal.getRefCode();
            }
        } else {
            Trace.trace(TRACE_MASKF, "getErrorCode() caught: " + exception);
        }
        Trace.trace(TRACE_MASKT, "<- getErrorCode(...) returning " + string);
        return string;
    }

    private static String createUniqueId(Vector vector) throws SFPException {
        String string = null;
        McResource mcResource = null;
        int n = 0;
        int n2 = 0;
        Exception exception = null;
        McAttribute mcAttribute = null;
        CtDataType[] ctDataTypeArray = null;
        ManagedObject managedObject = null;
        Trace.trace(TRACE_MASKT, "-> createUniqueId(" + vector + ")");
        if (vector != null && vector.size() > 0) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                mcResource = (McResource)iterator.next();
                Trace.trace(TRACE_MASKD, "Processing serviceable event of " + mcResource);
                try {
                    mcAttribute = mcResource.getPersistentAttribute(MANAGED_NODES_ATTRIBUTE_NAME);
                }
                catch (McErrNumException mcErrNumException) {
                    exception = new Exception(mcErrNumException.getMessage());
                }
                catch (CuException cuException) {
                    exception = new Exception(cuException.getMessage());
                }
                if (exception == null) {
                    if (mcAttribute == null || (ctDataTypeArray = ((CtArray)mcAttribute.getValue()).getData()).length <= 0 || (n2 = Integer.parseInt((managedObject = new ManagedObject((CtStructuredData)ctDataTypeArray[0], Locale.getDefault())).getOSType())) <= n) continue;
                    n = n2;
                    continue;
                }
                Trace.trace(TRACE_MASKF, "createUniqueId() caught: " + exception);
                throw new SFPException("", exception);
            }
        }
        if (n == 0) {
            string = String.valueOf(1);
        } else if (n != Integer.MAX_VALUE) {
            string = String.valueOf(n + 1);
        } else {
            int n3 = 1;
            while (n3 <= Integer.MAX_VALUE) {
                if (SurveillanceTimerThread.isIdUnique(n3, vector)) {
                    string = String.valueOf(n3);
                    break;
                }
                ++n3;
            }
            throw new SFPException("");
        }
        Trace.trace(TRACE_MASKT, "<- createUniqueId(" + vector + ") returning " + string);
        return string;
    }

    private static boolean isIdUnique(int n, Vector vector) throws SFPException {
        McResource mcResource = null;
        int n2 = 0;
        Exception exception = null;
        boolean bl = true;
        McAttribute mcAttribute = null;
        CtDataType[] ctDataTypeArray = null;
        ManagedObject managedObject = null;
        Trace.trace(TRACE_MASKT, "-> isIdUnique(" + n + ", " + vector + ")");
        if (vector != null && vector.size() > 0) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                mcResource = (McResource)iterator.next();
                try {
                    mcAttribute = mcResource.getPersistentAttribute(MANAGED_NODES_ATTRIBUTE_NAME);
                }
                catch (McErrNumException mcErrNumException) {
                    exception = new Exception(mcErrNumException.getMessage());
                }
                catch (CuException cuException) {
                    exception = new Exception(cuException.getMessage());
                }
                if (exception == null) {
                    if (mcAttribute == null || (ctDataTypeArray = ((CtArray)mcAttribute.getValue()).getData()).length <= 0 || (n2 = Integer.parseInt((managedObject = new ManagedObject((CtStructuredData)ctDataTypeArray[0], Locale.getDefault())).getOSType())) != n) continue;
                    bl = false;
                    break;
                }
                Trace.trace(TRACE_MASKF, "isIdUnique() caught: " + exception);
                throw new SFPException("", exception);
            }
        }
        Trace.trace(TRACE_MASKT, "<- isIdUnique(" + n + ", " + vector + ") returning " + bl);
        return bl;
    }

    private static void createSE(SurveillanceEvent surveillanceEvent, String string) throws SFPException {
        Locale locale = Locale.getDefault();
        Trace.trace(TRACE_MASKD, "HMC locale is " + locale.toString());
        String[] stringArray = null;
        stringArray = new String[]{surveillanceEvent.getPartitionName()};
        RMCUtils.makeSurvSE(surveillanceEvent.getErrorCode(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionName(), surveillanceEvent.getPartitionId(), surveillanceEvent.getHostName(), Surveillance.getTranslatedErrorText(Locale.ENGLISH.getLanguage(), Locale.US.getCountry(), surveillanceEvent.getPartitionName(), surveillanceEvent.getErrorCode()), string, new Date(), "SFPResourceBundleMessages", "0109", stringArray);
    }

    private static String getNonEnUSTranslatedErrorText(Locale locale, String string, String string2) {
        if (locale.equals(ENGLISH_US)) {
            return "";
        }
        return Surveillance.getTranslatedErrorText(locale.getLanguage(), locale.getCountry(), string, string2);
    }

    private ManagedObjectEntry getPartitionInSE(String string, McResource mcResource) {
        McAttribute mcAttribute = null;
        CtDataType[] ctDataTypeArray = null;
        ManagedObject managedObject = null;
        Exception exception = null;
        CtArray ctArray = null;
        try {
            mcAttribute = mcResource.getPersistentAttribute(MANAGED_NODES_ATTRIBUTE_NAME);
        }
        catch (McErrNumException mcErrNumException) {
            exception = new Exception(mcErrNumException.getMessage());
        }
        catch (CuException cuException) {
            exception = new Exception(cuException.getMessage());
        }
        if (exception == null) {
            if (mcAttribute != null) {
                ctArray = (CtArray)mcAttribute.getValue();
                ctDataTypeArray = ctArray.getData();
                int n = 0;
                while (n < ctDataTypeArray.length) {
                    managedObject = new ManagedObject((CtStructuredData)ctDataTypeArray[n], Locale.getDefault());
                    if (string.equals(managedObject.getPartitionId())) {
                        return new ManagedObjectEntry(mcAttribute, ctDataTypeArray, n);
                    }
                    ++n;
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "isPartitionInSE() caught: " + exception);
        }
        return null;
    }

    private static void addPartition(SurveillanceEvent surveillanceEvent, McResource mcResource, Date date) throws SFPException {
        ServiceableEvent serviceableEvent = null;
        ManagedObject[] managedObjectArray = null;
        Locale locale = null;
        Trace.trace(TRACE_MASKT, "-> addPartition(" + surveillanceEvent + ", " + mcResource + ", " + date + ")");
        serviceableEvent = new ServiceableEvent(mcResource);
        managedObjectArray = serviceableEvent.getManagedObjects();
        locale = Locale.getDefault();
        String[] stringArray = null;
        stringArray = new String[]{surveillanceEvent.getPartitionName()};
        RMCUtils.makeSurvSE(surveillanceEvent.getErrorCode(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionName(), surveillanceEvent.getPartitionId(), surveillanceEvent.getHostName(), Surveillance.getTranslatedErrorText(Locale.ENGLISH.getLanguage(), Locale.US.getCountry(), surveillanceEvent.getPartitionName(), surveillanceEvent.getErrorCode()), managedObjectArray[0].getOSType(), date, "SFPResourceBundleMessages", "0109", stringArray);
        Trace.trace(TRACE_MASKT, "<- addPartition(...)");
    }

    private static void incDup(ManagedObjectEntry managedObjectEntry, McResource mcResource, Date date) throws SFPException {
        McAttribute mcAttribute = null;
        CtDataType[] ctDataTypeArray = null;
        Object var5_5 = null;
        ManagedObject managedObject = null;
        FRUOriginal[] fRUOriginalArray = null;
        String string = null;
        ServiceableEvent serviceableEvent = null;
        Object var10_10 = null;
        Object var11_11 = null;
        String string2 = "";
        String string3 = "";
        Trace.trace(TRACE_MASKT, "-> incDup(" + managedObjectEntry + ", " + mcResource + ", " + date + ")");
        mcAttribute = managedObjectEntry.getManagedNodes();
        ctDataTypeArray = managedObjectEntry.getManagedObjects();
        managedObject = new ManagedObject((CtStructuredData)ctDataTypeArray[managedObjectEntry.getIndex()], Locale.getDefault());
        serviceableEvent = new ServiceableEvent(mcResource);
        fRUOriginalArray = serviceableEvent.getFRUListOriginal();
        string = fRUOriginalArray != null && fRUOriginalArray.length > 0 ? fRUOriginalArray[0].getRefCode() : "";
        String[] stringArray = null;
        stringArray = new String[]{managedObject.getPartitionName()};
        RMCUtils.makeSurvSE(string, managedObject.getCecMT()[0], managedObject.getCecMS()[0], managedObject.getDevMT(), managedObject.getDevMS(), managedObject.getPartitionName(), managedObject.getPartitionId(), managedObject.getHostName(), managedObject.getDefaultErrorText(), managedObject.getOSType(), date, "SFPResourceBundleMessages", "0109", stringArray, new ArrayList<String>(Arrays.asList(managedObject.getNLSLocales())), new ArrayList<String>(Arrays.asList(managedObject.getNLSErrorTexts())));
        Trace.trace(TRACE_MASKT, "<- incDup(...)");
    }

    private McSession createSession() throws SFPException {
        Trace.trace(TRACE_MASKT, "-> createSession()");
        Trace.trace(TRACE_MASKF, "createSession() about to create thread to start session");
        SessionThread sessionThread = new SessionThread();
        Trace.trace(TRACE_MASKF, "createSession() about to launch thread to start session");
        sessionThread.start();
        try {
            sessionThread.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sessionThread.getSession() == null) {
            Trace.trace(TRACE_MASKF, "createSession() could not create a session");
            throw new SFPException("0107");
        }
        Trace.trace(TRACE_MASKF, "createSession() created a session successfully");
        return sessionThread.getSession();
    }

    private static Vector getSEs(McSession mcSession, String string, String string2) throws SFPException {
        Vector vector = new Vector();
        McResourceClass mcResourceClass = null;
        Trace.trace(TRACE_MASKT, "-> getSEs()");
        try {
            Trace.trace(TRACE_MASKF, "getSEs() about to create a McResourceClass");
            mcResourceClass = new McResourceClass(mcSession, "IBM.ServiceEvent");
            vector = mcResourceClass.getResources("Nodes[0].ErrorClass=='SURVALNC' && Nodes[0].CecMT=='" + string + "' && Nodes[0].CecMS='" + string2 + "' && Status=='" + "Open" + "'");
        }
        catch (McErrNumException mcErrNumException) {
            Trace.trace(TRACE_MASKF, "getResources failed : " + (Object)((Object)mcErrNumException));
            throw new SFPException("0113", new Exception(mcErrNumException.getMessage()));
        }
        catch (CuException cuException) {
            Trace.trace(TRACE_MASKF, "getResources failed : " + (Object)((Object)cuException));
            throw new SFPException("0113", new Exception(cuException.getMessage()));
        }
        Trace.trace(TRACE_MASKT, "<- getSEs()");
        return vector;
    }

    private class ManagedObjectEntry {
        private McAttribute managedNodes = null;
        private CtDataType[] managedObjects = null;
        private int index = 0;

        ManagedObjectEntry(McAttribute mcAttribute, CtDataType[] ctDataTypeArray, int n) {
            this.managedNodes = mcAttribute;
            this.managedObjects = ctDataTypeArray;
            this.index = n;
        }

        McAttribute getManagedNodes() {
            return this.managedNodes;
        }

        CtDataType[] getManagedObjects() {
            return this.managedObjects;
        }

        int getIndex() {
            return this.index;
        }
    }

    class SessionEndedHandler
    implements McSessionEndedCB {
        SessionEndedHandler() {
        }

        public void sessionEnded(Object object) {
            Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "-> SessionEndedHandler.sessionEnded()");
            Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "<- SessionEndedHandler.sessionEnded()");
        }

        public void sessionInterrupted(Object object) {
            Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "-> SessionEndedHandler.sessionInterrupted()");
            Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "<- SessionEndedHandler.sessionInterrupted()");
        }
    }

    private class SessionThread
    extends Thread {
        private McSession sessionToRMC = null;

        private SessionThread() {
        }

        public void run() {
            try {
                Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "-> SessionThread.run()");
                this.establishSession();
            }
            catch (SFPException sFPException) {
                Trace.trace(SurveillanceTimerThread.TRACE_MASKF, "SessionThread.run() can't start session: " + sFPException);
            }
            Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "<- SessionThread.run()");
        }

        private void establishSession() throws SFPException {
            Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "-> establishSession()");
            try {
                Trace.trace(SurveillanceTimerThread.TRACE_MASKF, "establishSession() about to create a McSession");
                this.sessionToRMC = new McSession((McSessionEndedCB)new SessionEndedHandler(), new Object());
            }
            catch (CuException cuException) {
                Trace.trace(SurveillanceTimerThread.TRACE_MASKF, "establishSession() failed creating session " + (Object)((Object)cuException));
                throw new SFPException("0107", new Exception(cuException.getMessage()));
            }
            Trace.trace(SurveillanceTimerThread.TRACE_MASKT, "<- establishSession()");
        }

        McSession getSession() {
            return this.sessionToRMC;
        }
    }
}

